
## 
## Copyright (c) 1999 by Kenjiro Taura, Akinori Yonezawa. All rights reserved.
## Copyright (c) 1999 by Yoshihiro Oyama, Toshio Endo. All rights reserved.
## Copyright (c) 1999 by Kunio Tabata. All rights reserved.
## Copyright (c) 1999 by Mitsubishi Research Institute.  All rights reserved.
## Copyright (c) 1999 by Information-technology Promotion Agency.  All rights reserved.
##
## THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
## OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
##
## Permission is hereby granted to use or copy this program
## for any purpose,  provided the above notices are retained on all copies.
## Permission to modify the code and to distribute modified code is granted,
## provided the above notices are retained, and a notice that the code was
## modified is included with the above copyright notice.
##

function show_head_indicator(fp, s)
{
  dfp = disp_coordinate_y(fp);
  printf("\\put(0,%d){\\makebox(20,0)[lb]{%s}}\n", dfp + 2, s);
  printf("\\put(0,%d){\\vector(1,0){%d}}\n", 
	 dfp, stack_left);
}

function show_frame (cfp, this_fp, name, nc, nf) {

  # print a vector that connects child frame and this frame

  printf("%%%% frame %d : %s (@ %x = %d) in chain %s\n", 
	 nf, name, this_fp, this_fp, (c ? c - 1 : "t"));
  
  if (cfp != 0) {

# print a vector that goes from child to this frame or a vector that goes
# from child to outside stack
    if ($1 == "**" && frame_out_of_stack == 0) {
      printf("%%%% a vector that goes out from the stack\n");
      printf("\\put(%d,%d){\\vector(-1,0){%d}}\n",
	     stack_left, disp_coordinate_y(cfp), stack_left);
      frame_out_of_stack = 1;
    } else if (frame_out_of_stack == 0) {
      printf("%%%% a link between child and this frame\n");

      if (this_fp > cfp) { diff = this_fp - cfp; }
      else { diff = cfp - this_fp; }
      if (diff % 2 == 1) {
	radius = ((diff + 1) / 2);
      } else {
	radius = (diff / 2);
      } 
      if (this_fp > cfp) {
	center = this_fp - radius;
	if (last_vector_direction != "minus") {
	  oval_width += 4;
	  last_vector_direction = "minus";
	}
      } else {
	center = this_fp + radius;
	if (last_vector_direction != "plus") {
	  oval_width += 4;
	  last_vector_direction = "plus";
	}
      }
      
      printf("\\put(%d,%d){\\oval(%d,%d)[l]}\n", stack_left,
	     disp_coordinate_y(center), oval_width, 2 * radius / SCALE);
      
      if (disp_coordinate_y(cfp) > disp_coordinate_y(this_fp)) {
	printf("\\put(%d,%d){\\vector(4,-1){0}}\n", 
	       stack_left, disp_coordinate_y(this_fp));
      } else {
	printf("\\put(%d,%d){\\vector(4,1){0}}\n", 
	       stack_left, disp_coordinate_y(this_fp));
      }
    }
  }  
  if (frame_out_of_stack) {
    printf("%%%% this frame is out of stack (do not print)\n");
  } else {
    printf("%%%% line at FP position and procedure's name\n");
    dfp = disp_coordinate_y(this_fp);
    
    if (nc) {
      id = sprintf("$c_{%d,%d}$", nc - 1, nf);
    } else {
      id = sprintf("$t_{%d}$", nf);
    }
    
    if (written[dfp] == 0) { 
      s = sprintf("\\verb+%s+(%s)", 
		  printable_name(name), id);
      written[dfp] = s;
      
      printf("\\put(%d,%d){\\makebox(%d,0)[lb]{%s}}\n",
	     stack_left + 5, dfp + 3, stack_width, s);
    } else {
      s = written[dfp];
      s = sprintf("\\phantom{%s}(%s)", s, id);
      
      written[dfp] = s;
      printf("\\put(%d,%d){\\makebox(%d,0)[lb]{%s}}\n",
	     stack_left + 5, dfp + 3, stack_width, s);
    }
    printf("\\put(%d,%d){\\line(1,0){%d}}\n", 
	   stack_left, dfp, stack_width);
  }
}

function show_end_vector(cfp)
{

  printf("%%%% chain was too long, the rest of the chain is omitted.\n");
  
  if (frame_out_of_stack) {
      printf("%%%% the chain is already out of stack (do not print)\n");
  } else {
      printf("\\put(%d,%d){\\vector(-1,0){%d}}\n",
	     stack_left, disp_coordinate_y(cfp), stack_left);
  }
}


function init_picture_env()
{
  if (stack_grows_downwards) {
    stack_top = $9 + stack_top_shrink;
  } else {
    stack_top = $9 - stack_top_shrink;
  }
  oval_width = 10;
  capcon_removed = 0;
  delete written;
}

function init_capcon_env()
{
  if ($19 == "removed") capcon_removed = 1;
  else {
    capcon_removed = 0;
    oval_width += 10;
  }
}

function disp_coordinate_y(x)
{
  return (stack_top - x) / SCALE;
}

function printable_name(x)
{
  gsub(/_/, "\\_", x); 
  return x;
}

function safe_getline()
{
  x = getline;
  if (x == 0) EOF = 1;
}

function is_fork_marker() 
{
  return (NF == 1 && $1 == "-----");
}

function is_more_frames()
{
    return ($0 == "... (more frames)");
}

function is_frame_info() 
{
  return (NF == 8 && 
	  ($1 == "**" || $1 == "--") && 
	  $3 == "@" && $5 == "=" && $7 == ":");
}

function is_stack_trace_and_contexts_start()
{
  if (NF < 9) return 0;
  if ($1 != "thread") return 0;
  if ($3 != "stack") return 0;
  if ($4 != "and") return 0;
  if ($5 != "captured") return 0;
  if ($6 != "contexts:") return 0;
  if ($7 != "title") return 0;
  if ($8 != "=") return 0;
  return 1;
}

function get_title()
{
  s = "stack and captured contexts: title = ";
  idx = match($0, s);
  l = idx + length(s);
  return substr($0, l);
}

function is_stack_trace_start()
{
  # "thread 0 stack trace: SP = 80474a8 = 134509736"
  if (NF != 9) return 0;
  if ($1 != "thread") return 0;
  if ($3 != "stack") return 0;
  if ($4 != "trace:") return 0;
  if ($5 != "SP") return 0;
  else return 1;
}

function is_capcon_start()
{
  # "thread 0 captured context: 0 : FP = 804777c = 134510460 PC = 804cab1 n_threads = 1 [ unremoved valid ]"
    if (NF != 21) return 0;
    if ($1 != "thread") return 0;
    if ($3 != "captured") return 0;
    if ($4 != "context:") return 0;
    if ($6 != ":") return 0;
    if ($7 != "FP") return 0;
    if ($8 != "=") return 0;
    else return 1;
}

function new_bottom_fp(old, new)
{
  if (old == 0) return new;
  if(stack_grows_downwards) {
    if (new > old) return new;
    else return old;
  } else {
    if (new < old) return new;
    else return old;
  }
}


function begin_picture()
{
  printf("\\begin{picture}(0,0)\n");
}

function close_picture(bottom_fp)
{
  printf("%%%% closing picture (bottom_fp = %x)\n", bottom_fp);
  dfp = disp_coordinate_y(bottom_fp);
  if (dfp < 0) l = -dfp; else l = dfp;
# vertical line that runs the left side of the stack
  printf("\\put(%d,%d){\\line(0,1){%d}}\n", stack_left, dfp, l);
# vertical line that runs the right side of the stack
  printf("\\put(%d,%d){\\line(0,1){%d}}\n", stack_left + stack_width, dfp, l);
# horizontal line that runs the top of the stack
  printf("\\put(%d,0){\\line(1,0){%d}}\n", stack_left, stack_width);
  printf("\\end{picture}\n\\newpage\n\n\n");
}

function write_header()
{
  printf("\\documentstyle[]{jarticle}\n");
  printf("\\begin{document}\n\n\n");
}

function write_trailer()
{
  printf("\\end{document}\n\n\n");
}

function main ()
{
  EOF = 0;
  if (SCALE == 0) SCALE = 1;
  stack_left = 50;
  stack_width = 200;
  stack_grows_downwards = 1;
  stack_top_shrink = 750 / SCALE;
  showing = 0;
  show_removed_frames = 0;
  max_chains = 2;

  write_header();

  while(!EOF) {
    if (is_stack_trace_and_contexts_start()) {
# this line begins a new stack trace and contexts
      if (showing) {
	close_picture(bottom_fp);
	showing = 0;
      }
      printf("%%%% title line %s\n", $0);
      printf("\n\\begin{center}%s\\end{center}\n\n", get_title());
      safe_getline();
    } if (is_stack_trace_start()) {
# this line begins a stack trace
      showing = 1;
      printf("%%%% stack trace begin at line %d (%s)\n", FNR, $0);
      init_picture_env();
      begin_picture();
      bottom_fp = 0;
      n_chains = 0;		
      n_frames_in_this_chain = 0; 
      frame_out_of_stack = 0;
      prev_fp = 0;
      safe_getline();
    } if (is_capcon_start()) {
# this line begins a captured context
      printf("%%%% capcon begin at line %d (%s)\n", FNR, $0);
      n_chains++;
      if (n_chains <= max_chains) {
	init_capcon_env();
	n_frames_in_this_chain = 0;
	frame_out_of_stack = 0;
	prev_fp = 0;
      }
      safe_getline();
    } else if (is_fork_marker()) {
      next_frame_forked_a_thread = 1;
      safe_getline();
    } else if (is_more_frames()) {
      if (n_chains <= max_chains) {
	show_end_vector(prev_fp);
      }
      safe_getline();
    } else if (is_frame_info()) {
      if (n_chains <= max_chains) {
	this_fp = $6;
	this_frame_name = $8;
      
	if (n_frames_in_this_chain == 0) {
	  if (n_chains == 0) {
	    s = "$t$";
	  } else if (capcon_removed) {
	    s = sprintf("$C_%s^{\\times}$", n_chains - 1);
	  } else {
	    s = sprintf("$C_%s$", n_chains - 1);
	  }
	  show_head_indicator(this_fp, s);
	}

	if (show_removed_frames || (capcon_removed == 0)) {
	  show_frame(prev_fp, this_fp, this_frame_name, 
		     n_chains, n_frames_in_this_chain);
	  if(!frame_out_of_stack) {
	    bottom_fp = new_bottom_fp(bottom_fp, this_fp);
	  }
	  prev_fp = this_fp;
	  next_frame_forked_a_thread = 0;
	}
	n_frames_in_this_chain++;
      }
      safe_getline();
    } else {
      if (showing) {
	close_picture(bottom_fp);
	showing = 0;
      }
      safe_getline();		# unknown line
    }
  }
  if (showing) close_picture(bottom_fp);

  write_trailer();

}

{
  if(NR == 1) main();
  else { 
    printf("error: do everything in main. do not use next command\n");
    exit 1;
  }
}
