
## 
## Copyright (c) 1999 by Kenjiro Taura, Akinori Yonezawa. All rights reserved.
## Copyright (c) 1999 by Yoshihiro Oyama, Toshio Endo. All rights reserved.
## Copyright (c) 1999 by Kunio Tabata. All rights reserved.
## Copyright (c) 1999 by Mitsubishi Research Institute.  All rights reserved.
## Copyright (c) 1999 by Information-technology Promotion Agency.  All rights reserved.
##
## THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
## OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
##
## Permission is hereby granted to use or copy this program
## for any purpose,  provided the above notices are retained on all copies.
## Permission to modify the code and to distribute modified code is granted,
## provided the above notices are retained, and a notice that the code was
## modified is included with the above copyright notice.
##

# 1 if this line is "#pragma gccext"
function is_pragma_gccext()
{
  if (NF == 2 && $1 == "#pragma" && $2 == "gccext") {
    return 1;
  } else {
    return 0;
  }
}

# (1) do not print "#pragma gccext"
# (2) replace GCC_EXT(xxx) with an empty string
function preprocess_line()
{
# the previous line was "#pragma gccext"
  if (G_pragma_gccext) {
    print;
# find GCC_EXT(xxx) and remove them
    gsub(/GCC_EXT\([^\)]*\)*/, ""); 
  } 

  if (is_pragma_gccext()) {
    G_pragma_gccext = 1;
  } else {
    G_pragma_gccext = 0;
  }
}

function preprocess_main(pid)
{
  G_pragma_gccext = 0;
  C_replaced_lines = "rep_" pid;

  preprocess_line();
  while(getline) {
    preprocess_line();
  }
  return 0;
}

function postprocess_line(f)
{
# the previous line was "#pragma gccext"
  if (G_pragma_gccext) {
    s = $0
    x = (getline < f);
    if (x == 0) {
      printf("error : inconsistent st.h and replace file (abort)");
      exit(1);
    }
    print $0;
    print "#if 0 /* removed */";
    print s;
    print "#endif /* 0 */";
  } else {
    print;
  }

  if (is_pragma_gccext()) {
    G_pragma_gccext = 1;
  } else {
    G_pragma_gccext = 0;
  }
}

function postprocess_main(f)
{
  postprocess_line(f);
  while(getline) {
    postprocess_line(f);
  }
  return 0;
}

function gccext_main()
{
  if (TASK == "preprocess") {
    if (PID == 0) {
      printf("give PID=$$ at the command line\n") >> "/dev/stderr";
      return 1;
    } else {
      r = preprocess_main(PID);
      return r;
    }
  } else if (TASK == "postprocess") {
    if (REPLACED_LINES == 0) {
      printf("give REPLACED_LINES=.. at the command line\n") >> "/dev/stderr";
      return 1;
    } else {
      r = postprocess_main(REPLACED_LINES);
      return r;
    }
  } else {
    printf("give TASK=.. at the command line\n") >> "/dev/stderr";
    return 1;
  }
}

{
  if (NR == 1) {
    r = gccext_main();
    exit(r);
  } else {
    printf("do everything in main (you probably used next command)\n");
    exit(1);
  }
}
