
## 
## Copyright (c) 1999 by Kenjiro Taura, Akinori Yonezawa. All rights reserved.
## Copyright (c) 1999 by Yoshihiro Oyama, Toshio Endo. All rights reserved.
## Copyright (c) 1999 by Kunio Tabata. All rights reserved.
## Copyright (c) 1999 by Mitsubishi Research Institute.  All rights reserved.
## Copyright (c) 1999 by Information-technology Promotion Agency.  All rights reserved.
##
## THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
## OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
##
## Permission is hereby granted to use or copy this program
## for any purpose,  provided the above notices are retained on all copies.
## Permission to modify the code and to distribute modified code is granted,
## provided the above notices are retained, and a notice that the code was
## modified is included with the above copyright notice.
##

# process file named FILE for processor P. select lines of state STATE
function process_file(file, p, state,
		      err)
{
  err = 0;
  while (getline < file) {
    # move x, y
    # x + dx, y
    if ($1 == state) {
      if (NF == 3) {
	printf("move %s %d\n%s %d\n", $2, p, $3, p);
	accum_time[state] += ($3 - $2);
      } else {
	fprintf("%s:%d file is broken\n", file, FNR) > "/dev/stderr";
	err = 1;
	break;
      }
    }
  }
  close(file);
  return err;
}

function init_states_string(\
			    s)
{
#  split("busy steal sleep idle switch delete_frame serv_steal spin msg serv_msg setup_worker idle start end", states_string, " ");
  split("busy steal sleep switch delete_frame serv_steal", states_string, " ");
  n_states = 0;
  for (x in states_string) n_states++;
}

# lw : line width
function write_header(lw)
{
  print "TitleText: Processor Status";
  print "BoundBox: true";
  print "Ticks: true";
  print "TitleFont: Times-18";
  print "LabelFont: Helvetica-18";
  print "XUnitText: microseconds";
  print "YUnitText: Processor ID";
  if (lw) {
    print "LineWidth: " lw;
  }
}

function file_exists(f)
{
  return (0 == system(sprintf("ls %s > /dev/null 2> /dev/null", f)));
}

function remove_file(file)
{
  system(sprintf("rm %s", file));
}


function mkxgrp_main (\
                      prefix, np, p, i, s, err)
{
  if (NF != 2) {
    printf("usage : mkxgrp filename_prefix N_of_procs\n") > "/dev/stderr";
    exit(1);
  }
  prefix = $1;
  np = $2;

  delete accum_time;
  init_states_string();
  write_header(18);

  err = 0;
  for (s = 1; s <= n_states; s++) {
    printf("\n\"%s\"\n", states_string[s]);
# for each processor P
    for (p = 0; p < np; p++) {
      i = 0;
# look for a file "prefix.P.?"
      while(file_exists(prefix "." p "." i)) {
# if exists, process that file
	err = process_file(prefix "." p "." i, p, states_string[s]);
	if (err) break;
	i++;
      }
      if (err) break;
    }
    if (err) break;
  }
# err = 1;
  if (err == 0){
# remove all files if everything was fine
    for (p = 0; p < np; p++) {
      i = 0; 
      while (file_exists(prefix "." p "." i)) {
	remove_file(prefix "." p "." i);
	i++;
      }
    }
  }

  for (s = 1; s <= n_states; s++) {
    printf("%s %d ", 
	   states_string[s], accum_time[states_string[s]]) > "/dev/stderr";
  }
  printf("\n") > "/dev/stderr";

  return err;
}

{
  if (NR == 1) {
    exit(mkxgrp_main());
  } else {
    print "do everyting in mkxgrp_main. do not use next"
  }
}
