
## 
## Copyright (c) 1999 by Kenjiro Taura, Akinori Yonezawa. All rights reserved.
## Copyright (c) 1999 by Yoshihiro Oyama, Toshio Endo. All rights reserved.
## Copyright (c) 1999 by Kunio Tabata. All rights reserved.
## Copyright (c) 1999 by Mitsubishi Research Institute.  All rights reserved.
## Copyright (c) 1999 by Information-technology Promotion Agency.  All rights reserved.
##
## THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
## OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
##
## Permission is hereby granted to use or copy this program
## for any purpose,  provided the above notices are retained on all copies.
## Permission to modify the code and to distribute modified code is granted,
## provided the above notices are retained, and a notice that the code was
## modified is included with the above copyright notice.
##

# usage: echo 'linker command line' | gawk -f stlink.awk
# ex.
#     echo gcc -o app app.o -lstext -lst | gawk -f stlink.awk THIS_COMMAND=pathname_for_this_command
#

function st_cpu_unset_error()
{
    printf("tblpp.awk : set ST_CPU_TYPE environment variable\n") > "/dev/stderr";
    exit 1;
}

function st_os_unset_error()
{
    printf("tblpp.awk : set ST_OS_TYPE environment variable\n") > "/dev/stderr";
    exit 1;
}

function machine_config(c, o)
{
  CPU = c;
  OS = o;

  supported_config["i386","winnt"] = 1;
  supported_config["i386","solaris"] = 1;
  supported_config["i386","linux"] = 1;
  supported_config["mips","irix"] = 1;
  supported_config["sparc","solaris"] = 1;
  supported_config["alpha","osf1"] = 1;
  supported_config["alpha","linux"] = 1;

  if (CPU == 0) st_cpu_unset_error();
  if (OS == 0) st_os_unset_error();
  if (supported_config[CPU,OS] == 0) unknown_configuration();

  if (OS == "solaris") {
    C_sym_prefix = 0;
  } else if (OS == "linux") {
    C_sym_prefix = 0;
  } else if (OS == "winnt") {
    C_sym_prefix = "_";
  } else if (OS == "irix") {
    C_sym_prefix = 0;
  } else if (OS == "osf1") {
    C_sym_prefix = 0;
  } else unknown_os_error();
}

function chop_ctrl_M()
{
# this is not necessary on b20
#  $0 = substr($0,1,length($0)-1);
}

# given assembler name, return its original C name (normally remove 
# first "_")
function asm_sym_to_C_sym(s)
{
  if (C_sym_prefix) return substr(s, length(C_sym_prefix)+1, length(s)-1); 
  else return s;
}

function my_system(cmd)
{
    if (show_commands) printf("%s\n", cmd) > "/dev/stderr";
    x = system(cmd);
# I don't know what's wrong here.
# On windows NT, we must do this to flush buffered output. 
# (otherwise, output from CMD is not printed until we issue next command)
    if (OS == "winnt") {
      system("echo -n");		# flush buffered output
    }
    if (show_commands) {
	if (x == 0) {
	    printf("OK\n") > "/dev/stderr";
	} else {
	    printf("NOT OK\n") > "/dev/stderr";
	}
    }
    return x;
}

function close_temps()
{
    close(decl_proc_info_table_file);
    close(proc_info_table_file);
    close(decl_data_info_table_file);
    close(data_info_table_file);
    close(decl_thread_start_hook_file);
    close(thread_start_hook_file);
    close(decl_worker_start_hook_file);
    close(worker_start_hook_file);
    # close(decl_toplevel_worker_start_hook_file);
    # close(toplevel_worker_start_hook_file);
}

function rm_temps()
{
    rmcmd = sprintf("rm -f %s %s %s %s %s %s %s %s", 
		    decl_proc_info_table_file, proc_info_table_file, 
		    decl_data_info_table_file, data_info_table_file, 
		    decl_thread_start_hook_file, thread_start_hook_file,
		    decl_worker_start_hook_file, worker_start_hook_file);
# decl_toplevel_worker_start_hook_file, toplevel_worker_start_hook_file
    my_system(rmcmd);
}

function find_lib(libname, i)
{
  for (i = 0; i < n_libpaths; i++) {
    name = libpath_list[i] "/lib" libname ".a";
    if (my_system(sprintf(test_command, name)) == 0) {
      return name;
    }
  }
  return 0;
}

function is_file_name(s)
{
  return substr(s, 1, 1) != "-";
}

# should be useful, but does not work on NT
#function getpid()
#{
#  save_current_line = $0;
#  getline < "/dev/pid";
#  r = $1;
#  close("/dev/pid");
#  $0 = save_current_line;
#  return r;
#}

function is_stlink_option(arg)
{
  if (arg == "--leave_tmps") return 1;
  else if (arg == "--leave_link_file") return 1;
  else if (arg == "--show_commands") return 1;
  else if (match(arg, /^--compiler=/)) return 1;
  else if (match(arg, /^--linker=/)) return 1;
  else if (arg == "--dbg") return 1;
  else return 0;
}

function linker_modoki()
{
  if (ST_DIR == 0) {
    printf("give ST_DIR=... in command line\n") > "/dev/stderr";
    exit 1;
  }
  this_command = THIS_COMMAND;
  if(show_commands) print "this command's name = " this_command;

  link_file_base = sprintf("__linkfile%d", PID);

  compiler = "gcc";
  linker = "gcc";
  nm_command = "nm";
#  nm_command = "/usr/local/bin/nm";
#  nm_command = "/bin/nm";
#  nm_command = "/usr/bin/nm";
#  nm_command = "/usr/lib/nm";
#  test_command = "ls %s > /dev/null 2> /dev/null";
  test_command = "test -f %s";
  
  delete libpath_list;
  n_libpaths = 0;
  
  delete objects_list;
  n_objs = 0;

  args = "";
  
  if (OS == "winnt") chop_ctrl_M();
  for (i = 1; i <= NF; i++) {
    arg = $i;
    if (!is_stlink_option(arg)) args = args " " arg;

# recognize -L options and -l options to find the locations of files 
# to be linked
    if ((idx = match(arg, /^-L/)) == 1) {
      p = substr(arg, 3);
      if (show_commands) printf("find libpath %s\n", p) > "/dev/stderr";
      libpath_list[n_libpaths] = p;
      n_libpaths++;
    } else if ((idx = match(arg, /^-l/)) == 1) {
      l = substr(arg, 3);
      x = find_lib(l);
      if (x) {
	if (show_commands) {
	  printf("found lib file for %s (%s)\n", l, x) > "/dev/stderr";
	}
	objects_list[n_objs] = x;
	n_objs++;
      } else {
	if (VERBOSE) {
	  printf("stlink: lib%s.a won't be scanned for procedure table generation\n", l) > "/dev/stderr";
	}
      }
    } else if (i != 1 && !next_to_o && is_file_name(arg)) {
# found a file to be linked
      if (show_commands) printf("add %s to files\n", arg) > "/dev/stderr";
      objects_list[n_objs] = arg;
      n_objs++;
    } else if (match(arg, /^--compiler=/)) {
      compiler = substr(arg, RLENGTH+1);
    } else if (match(arg, /^--linker=/)) {
      linker = substr(arg, RLENGTH+1);
    } else if (match(arg, /^--show_commands/)) {
      show_commands = 1;
    } else if (match(arg, /^--leave_tmps/)) {
      leave_tmps = 1;
    } else if (match(arg, /^--leave_link_file/)) {
      leave_link_file = 1;
    } else if (arg == "--dbg") {
      show_commands = 1;
      leave_tmps = 1;
    }
    
    if ((idx = match(arg, /^-o/)) == 1) {
      next_to_o = 1;
    } else {
      next_to_o = 0;
    }
    
  }
  
# create empty temporary files
  printf("") > decl_proc_info_table_file;
  printf("") > proc_info_table_file;
  printf("") > decl_thread_start_hook_file;
  printf("") > thread_start_hook_file;
  printf("") > decl_worker_start_hook_file;
  printf("") > worker_start_hook_file;
  
  status = 0;
  for (i = 0; i < n_objs; i++) {
# check if the file exists
    cmd = sprintf("ls %s > /dev/null 2> /dev/null", objects_list[i]);
    status = my_system(cmd);
    if (status != 0) {
      missing_file = objects_list[i];
      break;
    }	
# run nm command
# nm -p filename | gawk -f stlink.awk WRITE_THINGS=1
    cmd = sprintf("%s %s | gawk -f %s WRITE_THINGS=1 THIS_COMMAND=%s SHOW_COMMANDS=%d PID=%s", 
		  nm_command, objects_list[i], this_command, this_command, 
		  show_commands, PID);
    status = my_system(cmd);
    if (status != 0) break;
  }
# files have been written. close them.
  close_temps();

  if (status != 0) {
      printf("stlink: file %s does not exist\n", missing_file) > "/dev/stderr";
      rm_temps();
      return 1;
  }

# embed the contents of temporary files into template at the end of this file
  cmd = sprintf("gawk -f %s PROCESS_TEMPLATE=1 THIS_COMMAND=%s SHOW_COMMANDS=%d PID=%s %s > %s.c",
		this_command, this_command, show_commands, PID, 
		this_command, link_file_base);
  status = my_system(cmd);

  if (status != 0) {
# cleanup .c file and finish
      printf("fail to generate link C file\n") > "/dev/stderr";
      if (!leave_tmps) {
	cmd = sprintf("rm -f %s.c", link_file_base);
	my_system(cmd);
	rm_temps();
      }
      return 1;
  }

# compile link_file
  cmd = sprintf("%s -I%s/include -g -c %s.c", compiler, ST_DIR, link_file_base);
  status = my_system(cmd);
  if (status != 0) {
      printf("fail to compile link C file\n") > "/dev/stderr";
      if (!leave_tmps) {
	cmd = sprintf("rm -f %s.c %s.o", link_file_base, link_file_base);
	my_system(cmd);
	rm_temps();
      }
      return 1;
  }
  
# link everything 
  cmd = sprintf("%s %s.o %s", linker, link_file_base, args);
  status = my_system(cmd);

  if (!leave_tmps) {
# remove link files (.c and .o)
    if (!leave_link_file) {
      cmd = sprintf("rm -f %s.c %s.o", link_file_base, link_file_base);
      my_system(cmd);
    }
    
# remove tmp files
    rm_temps();
  }

  return status;
}

# 1 if A has X as a suffix
function has_suffix(a, x)
{
  idx = match(a, x);
  if (idx == 0) return 0;
  else if (length(a) == length(x) + idx - 1) return 1;
  else reutrn 0;
}

function has_prefix(a, x)
{
  idx = match(a, x);
  if (idx == 1) return 1;
  else return 0;
}

function write_proc_info_table()
{
  if (match($0, /[^ \|]*_st_proc_info_zzz__$/)) {
    C_name = asm_sym_to_C_sym(substr($0, RSTART));
    if (show_commands) {
      printf("found proc_info_table %s (at line %d : %s)\n", C_name, NR, $0) > "/dev/stderr";
    }
    printf("  %s,\n", C_name) >> proc_info_table_file;
    printf("extern struct st_proc_info %s[];\n", 
	   C_name) >> decl_proc_info_table_file;
    return 1;
  } else {
    return 0;
  }
}

function write_data_info_table()
{
  if (match($0, /[^ \|]*_st_data_info_zzz__$/)) {
    C_name = asm_sym_to_C_sym(substr($0, RSTART));
    if (show_commands) {
      printf("found data_info_table %s (at line %d : %s)\n", C_name, NR, $0) > "/dev/stderr";
    }
    printf("  %s,\n", C_name) >> data_info_table_file;
    printf("extern struct st_data_info %s[];\n", 
	   C_name) >> decl_data_info_table_file;
    return 1;
  } else {
    return 0;
  }
}

function write_thread_start_hook()
{
  if (match($0, /[^ \|]*sthreads_thread_start_hook_.*/)) {
    C_name = asm_sym_to_C_sym(substr($0, RSTART));
    if (show_commands) {
	printf("found thread start hook %s (at line %d : %s)\n", 
	       C_name, NR, $0) >> "/dev/stderr";
    }
    printf("void %s();\n", C_name) >> decl_thread_start_hook_file;
    printf("  %s,\n", C_name) >> thread_start_hook_file;
    return 1;
  } else {
    return 0;
  }
}

function write_worker_start_hook()
{
  if (match($0, /[^ \|]*sthreads_worker_start_hook_.*/)) {
    C_name = asm_sym_to_C_sym(substr($0, RSTART));
    if (show_commands) {
	printf("found worker start hook %s (at line %d : %s)\n", 
	       C_name, NR, $0) >> "/dev/stderr";
    }
    printf("void %s();\n", C_name) >> decl_worker_start_hook_file;
    printf("  %s,\n", C_name) >> worker_start_hook_file;
    return 1;
  } else {
    return 0;
  }
}

function write_things(\
		      wpit)
{
  wpit = 0;
  do {
# on Windows NT, remove ctrl M (which will probably be output by nm command)
    if (OS == "winnt") chop_ctrl_M();
    wpit += write_proc_info_table();
    write_data_info_table();
    write_thread_start_hook();
    write_worker_start_hook();
  } while (getline);
  close_temps();
  return 0;
}

function process_template()
{
  do {
    if ($1 == "#" && $2 == "xxx") {
      if ($3 == "@") {
	my_system("cat " $4 PID ".lt");
	if ($4 == "__pit") {
# check if the file has no lines
# wc __pitXXX.lt | gawk '{ print  $1 }' | grep 0 > /dev/null
	  if (my_system("wc " $4 PID ".lt | gawk '{ if ($1 == 0) print "zero"; else print "ok"; }' | grep zero > /dev/null") == 0) {
	    printf("warning: no procedure tables are found\n") > "/dev/stderr";
	    printf("warning: nm may not be working?\n") > "/dev/stderr";
	  }
	}
      } else {
	for (i = 3; i <= NF; i++) printf("%s ", $i);
	printf("\n");
      }
    }
  } while(getline);
  close_temps();
  # rm_temps();
  return 0;
}

function common_setup()
{
# if you want to see messages like:
# stlink: libposix4.a won't be scanned for procedure table generation
# stlink: register worker_start_hook ...
# VERBOSE = 1;


# SHOW_COMMANDS=... should be given in gawk command line
  if (SHOW_COMMANDS) show_commands = 1;
  else show_commands = 0;

# remove temporaries by default
  leave_tmps = 0;

  if (THIS_COMMAND == 0) {
    printf("give THIS_COMMAND=... in command line\n") > "/dev/stderr";
    exit 1;
  }

  if (PID == 0) {
    printf("give PID=... in command line\n") > "/dev/stderr";
    exit 1;
  }

  decl_proc_info_table_file = "__dpit" PID ".lt";
  proc_info_table_file = "__pit" PID ".lt";
  decl_data_info_table_file = "__ddit" PID ".lt";
  data_info_table_file = "__dit" PID ".lt";
  decl_thread_start_hook_file = "__dtsh" PID ".lt";
  thread_start_hook_file = "__tsh" PID ".lt";
  decl_worker_start_hook_file = "__dwsh" PID ".lt";
  worker_start_hook_file = "__wsh" PID ".lt";
}

function main()
{
  common_setup();
  
  if (WRITE_THINGS) return write_things();
  else if (PROCESS_TEMPLATE) return process_template();
  else return linker_modoki();
}

BEGIN { 
  machine_config(ENVIRON["ST_CPU_TYPE"], ENVIRON["ST_OS_TYPE"]);
}

{
  if (NR == 1) {
    r = main();
    exit r;
  } else {
    printf("do not use next command. do everything within main\n");
    exit 1;
  }
}

# xxx #include "st.h"
# xxx
# xxx @ __dpit
# xxx
# xxx st_proc_info_t st_global_proc_info_xxx_[] = 
# xxx {
# xxx @ __pit
# xxx   0
# xxx };
# xxx
# xxx @ __ddit
# xxx
# xxx st_data_info_t st_global_data_info_xxx_[] = 
# xxx {
# xxx @ __dit
# xxx   0
# xxx };
# xxx
# xxx @ __dtsh
# xxx
# xxx thread_hook_t thread_start_hooks[] = {
# xxx @ __tsh
# xxx 0 
# xxx };
# xxx
# xxx @ __dwsh
# xxx
# xxx thread_hook_t worker_start_hooks[] = {
# xxx @ __wsh
# xxx 0 
# xxx };
# xxx
# xxx /* EndOfFile */

