#include <stdlib.h>
#include <st.h>

void bin(int n, int * r, st_join_counter_t * c)
{
  DECLARE_STACK_INV_CHECK;

  if (n == 0) {
    *r = 1;
    SAVE_STACK_INV();
    st_join_counter_finish(c);		/* say I have done */
    CHECK_STACK_INV();
  } else {
    st_join_counter_t cc[1];
    int a, b;
    ST_POLLING();
    st_join_counter_init(cc, 2);

    SAVE_STACK_INV();
    ST_THREAD_CREATE(bin(n - 1, &a, cc));
    CHECK_STACK_INV();
    SAVE_STACK_INV();
    bin(n - 1, &b, cc);
    CHECK_STACK_INV();
    SAVE_STACK_INV();
    st_join_counter_wait(cc);		/* wait for child's completion */
    CHECK_STACK_INV();
    *r = a + b;
    SAVE_STACK_INV();
    st_join_counter_finish(c);	/* say I have done */
    CHECK_STACK_INV();
    ST_POLLING();
  }
}

int st_main(int argc, char ** argv)
{
  DECLARE_STACK_INV_CHECK;
#if 0
  int n = atoi(argv[1]);
#else
  int n = 20;
#endif
  int r;
  long t0, t1;
  st_join_counter_t c[1];
  
  t0 = st_current_time_ms();
  {
    int i;
    for (i = 0; i < 1; i++) {
      st_join_counter_init(c, 1);
      SAVE_STACK_INV();
      bin(n, &r, c);
      CHECK_STACK_INV();
      SAVE_STACK_INV();
      st_join_counter_wait(c);
      CHECK_STACK_INV();
      if (r != (1 << n)) {
	printf("result is wrong\n");
	st_wg_die((void *)1);
      }
    }
  }
  t1 = st_current_time_ms();
  printf("2^%d = %d (%d ms) OK\n", n, r, t1 - t0);
  return 0;
}

