/* 
 * cb.c --- callback test
 */

#include <st.h>

int id_int(int);

/* this is called by qsort. tls should be invalid upon entry */
int less_than_p(int a, int b)
{
  FOREIGN_IF_BEGIN();
  int x = id_int(a);
  int y = id_int(b);
  FOREIGN_IF_END();
  return x - y;
}

int id_int(int x) { 
  return x; 
}

/* this is a procedure (in cbnopp.c) compiled via plain gcc and simply 
   calls qsort. it uses lots of callee save registers to make sure that 
   tls is invalid when less_than_p is called */
void non_st_func_qsort(int *, int, int, int (*)(int, int));

int n_iters = 2;
void * malloc(int);
int st_main()
{
  int n = 1000;
  int * a;
  void * sp;
  void * new_sp;
  int i;
  DECLARE_STACK_INV_CHECK;

  /* these loops actually iterate once. 
     by putting procedure calls in a loop, we make sure that
     the compiler cleans up pushed arguments */

  for (i = 0; i < n_iters; i++) {
    a = (int *)malloc(sizeof(int) * n);
    if (a) break;
  }
  sp = asm_get_sp();
  for (i = 0; i < n_iters; i++) {
    new_sp = asm_get_sp();
    if (i != 0) {
      if (sp == new_sp) {
	fprintf(st_errout, "OK\n");
      } else {
	fprintf(st_errout, "(SP before qsort =) %x != %x (= SP after qsort)\n",
		sp, new_sp);
      }
      return;
    }
    SAVE_STACK_INV();
    non_st_func_qsort(a, n, sizeof(int), less_than_p);
    CHECK_STACK_INV();
    /* in the first iteration, pushed arguments will be cleaned up here. */
  }
}
