/* st_cond.c - condition wait test for StackThreads2 */

#include <st.h>

static st_cond_t cond[1];
static st_mutex_t lock[1];

struct {
  st_mutex_t lock[1];
  int count;
} counter;

static volatile int my_condition = 0;

/* 800 */
#define WORKERS		800
#define DISTRIB		4

void distributer(st_join_counter_t * c)
{
  int i, j;
  for (i = 0; i < WORKERS / DISTRIB; i++) {
    st_mutex_lock(lock);
    my_condition += DISTRIB;
#if 0
    fprintf(st_errout, "remain: %d\n", my_condition);
#endif
    for (j = 0; j < DISTRIB; j++) {
      fprintf(st_errout, "signal %d\n", i * DISTRIB + j);
      st_cond_signal(cond);
    }
    st_mutex_unlock(lock);
    ST_POLLING();
    st_yield();
  }

  st_join_counter_finish(c);
  ST_POLLING();
}

void worker(st_join_counter_t * c)
{
  int iam;
  st_mutex_lock(counter.lock);
  iam = counter.count++;
  st_mutex_unlock(counter.lock);

  fprintf(st_errout, "worker <%d> start\n", iam);

  st_mutex_lock(lock);
  while (!my_condition) {
    st_cond_wait(cond, lock);
  }
#if 0
  fprintf(st_errout, "<%d>: i got good condition!\n", iam);
#endif
  my_condition--;
#if 0
  fprintf(st_errout, "remain: %d\n", my_condition);
#endif
  st_mutex_unlock(lock);
  ST_POLLING();

  st_join_counter_finish(c);
  ST_POLLING();

  fprintf(st_errout, "worker <%d> finish\n", iam);
}

int st_main (int argc, char **argv)
{
  int i;
  st_join_counter_t c[WORKERS + 1];
  
  st_cond_init(cond);
  st_mutex_init(lock);
  st_mutex_init(counter.lock);

  for (i = 0; i < WORKERS + 1; i++) {
    st_join_counter_init(&c[i], 1);
  }

  for (i = 0; i < WORKERS; i++) {
    ST_THREAD_CREATE(worker(&c[i+1]));
  }
  ST_THREAD_CREATE(distributer(c));

  //st_cond_broadcast(cond);

  for (i = 0; i < WORKERS + 1; i++) {
    ST_POLLING();
    printf("%d : SP = %p FP = %p stack = %ld bytes\n", 
	   i, asm_get_sp(), asm_get_fp(), st_stack_used_bytes());
    fflush(stdout);
    st_join_counter_wait(&c[i]);
  }
  printf("OK\n");
  fflush(stdout);
  return 0;
}
