/* 
 * cwg.c
 */

#include <st.h>

/* this is a procedure (in cwgnopp.c) compiled by the plain gcc that creates
   worker group that evaluates f(n) */
int my_create_worker_group(int (* f)(int), int n);

void bin(int n, int * r, st_join_counter_t * c)
{
  DECLARE_STACK_INV_CHECK;

  if (n == 0) {
    *r = 1;
    SAVE_STACK_INV();
    st_join_counter_finish(c);	/* say I have done */
    CHECK_STACK_INV();
  } else {
    st_join_counter_t cc[1];
    int a, b;
    ST_POLLING();
    st_join_counter_init(cc, 2);

    SAVE_STACK_INV();
    ST_THREAD_CREATE(bin(n - 1, &a, cc));
    CHECK_STACK_INV();
    SAVE_STACK_INV();
    bin(n - 1, &b, cc);
    CHECK_STACK_INV();
    SAVE_STACK_INV();
    st_join_counter_wait(cc);		/* wait for child's completion */
    CHECK_STACK_INV();
    *r = a + b;
    SAVE_STACK_INV();
    st_join_counter_finish(c);		/* say I have done */
    CHECK_STACK_INV();
    ST_POLLING();
  }
}

int f (int n)
{
  st_join_counter_t c[1];
  int r;
  DECLARE_STACK_INV_CHECK;

  st_join_counter_init(c, 1);
  SAVE_STACK_INV();
  bin(n, &r, c);
  CHECK_STACK_INV();
  SAVE_STACK_INV();
  st_join_counter_wait(c);
  CHECK_STACK_INV();
  if (r != (1 << n)) {
    printf("result is wrong\n");
    st_wg_die((void *)1);
  }
  return r;
}

int st_main()
{
  int n = 18;
  int iter = 10;
  int r;
  int i;
  for (i = 0; i < iter; i++) {
    r = my_create_worker_group(f, n);
    if (r != (1 << n)) {
      printf("result from my_create_worker_group is wrong (%d != %d)\n",
	     r, 1 << n);
      st_wg_die((void *)1);
    }
    printf("%d : bin(%d) = %d\nOK\n", i, n, r);
  }
  printf("OK\n");
}

