/*
 * istr_test.cc
 */

extern "C" {
#include <st.h>
    int atoi(char *);
}
#include <st_list.h>

#define ISTR_WAKEUP_IMMEDIATELY 1
#include <istr.h>

void sc_reader(istr<int> * buf, int n, istr<int> * ack)
{
    int i;
    int s = 0;
    DECLARE_STACK_INV_CHECK;
    for (i = 0; i < n; i++) {
	printf("try to read buf[%d]\n", i);
	SAVE_STACK_INV();
	int val = buf[i].get();	// this will block the reader
	CHECK_STACK_INV();
	s += val;
	printf("read %d\n", val);
    }
    SAVE_STACK_INV();
    ack->put(s);
    CHECK_STACK_INV();
}

void sc_writer(istr<int> * buf, int n, istr<int> * ack)
{
    int i;
    DECLARE_STACK_INV_CHECK;
    for (i = 0; i < n; i++) {
	printf("put %d\n", i);
	SAVE_STACK_INV();
	buf[i].put(i);		// this will unblock the reader
	CHECK_STACK_INV();
    }
    SAVE_STACK_INV();
    ack->put(0);
    CHECK_STACK_INV();
}

int st_main()
{
  int n = 10;
  int result;
  DECLARE_STACK_INV_CHECK;
  istr<int> * ack = new istr<int>[2];
  istr<int> * buf = new istr<int>[n];	// create N elements I-Structure
  SAVE_STACK_INV();
  PROC_FORK(sc_reader(buf, n, ack));	// create reader thread
  CHECK_STACK_INV();
  SAVE_STACK_INV();
  PROC_FORK(sc_writer(buf, n, ack + 1)); // create writer thread
  CHECK_STACK_INV();
  result = ack[0].get();
  printf("reader totally read %d\n", result);
  SAVE_STACK_INV();
  ack[1].get();
  CHECK_STACK_INV();
  if (result == n * (n - 1) / 2) {
    printf("OK\n");
  } else {
    printf("result is wrong\n");
  }
  return 0;
}

