/* 
 * susp.c --- the simplest test for suspension and restarting
 */

#include <st.h>

st_context_t bar_con = 0;

int bar(void)
{
  DECLARE_STACK_INV_CHECK;
  struct st_context c[1];
  c->valid = 0;
  bar_con = c;
  fprintf(st_errout, "3 : baz-bar blocks\n");
  SAVE_STACK_INV();
  st_suspend_thread_n(c, 1);
  CHECK_STACK_INV();
  fprintf(st_errout, "5 : bar restarted and finishes\n");
  bar_con = 0;
  return 0;
}

int foo(int a0, int a1, int a2, int a3, int a4, int a5, int a6)
{
  if (a1 != 100 || a2 != 200 || a3 != 300 || a4 != 400
      || a5 != 500 || a6 != 600) {
    fprintf(st_errout, 
	    "*******************************************************************\n"
	    "Arguments to foo(bar(0), 1, 2, 3, 4, 5, 6) are not passed correctly\n"
	    "This is a known problem on Pentium\n"
	    "You may either patch gcc to fix this problem (see manual),\n"
	    "or just avoid calling StackThreads procedures within another procedure call\n"
	    "*******************************************************************\n");
    st_wg_exit((void *)1);
  } else {
    st_assert(bar_con == 0);
    fprintf(st_errout, "6 : foo was called and finishes\n");
  }
  return 0;
}

int baz()
{
  DECLARE_STACK_INV_CHECK;
  fprintf(st_errout, "2 : baz calls foo(bar(), ...)\n");
  SAVE_STACK_INV();
  foo(bar(), 100, 200, 300, 400, 500, 600);
  CHECK_STACK_INV();
  fprintf(st_errout, "7 : foo finished, baz finishes\n");
  return 0;
}

int st_main()
{
  struct invalid_frame_desc iff[1];
  DECLARE_STACK_INV_CHECK;
  fprintf(st_errout, "1 : st_main forks baz()\n");
  ST_THREAD_CREATE(baz());
  fprintf(st_errout, "4 : baz-bar blocked, restart baz-bar\n");
  st_assert(bar_con);
  SAVE_STACK_INV();
  INVALID_CALL(st_restart_context_n(bar_con, iff, 1));
  CHECK_STACK_INV();
  fprintf(st_errout, "8 : baz finished\n");
  fprintf(st_errout, "9 : OK\n");
}

