/* 
 *
 */

#include <st.h>

void bar(st_join_counter_t * c, st_join_counter_t * d)
{
  DECLARE_STACK_INV_CHECK;
  fprintf(st_errout, "0 bar tries to wait C\n");
  SAVE_STACK_INV();
  st_join_counter_wait(c);
  CHECK_STACK_INV();
  fprintf(st_errout, "3 bar resumed\n");
  SAVE_STACK_INV();
  st_join_counter_finish(d);
  CHECK_STACK_INV();
  fprintf(st_errout, "4 bar finished\n");
}

void foo()
{
  DECLARE_STACK_INV_CHECK;
  st_join_counter_t c[1];
  st_join_counter_t d[1];
  st_join_counter_init(c, 1);
  st_join_counter_init(d, 1);
  SAVE_STACK_INV();
  ST_THREAD_CREATE(bar(c, d));	/* bar will block */
  CHECK_STACK_INV();
  fprintf(st_errout, "1 bar is blocked on C\n");
  SAVE_STACK_INV();
  st_join_counter_finish(c);
  CHECK_STACK_INV();
  fprintf(st_errout, "2 foo still continues\n");
  SAVE_STACK_INV();
  st_join_counter_wait(d);
  CHECK_STACK_INV();
  fprintf(st_errout, "5 foo finished\n");
}

int st_main()
{
  DECLARE_STACK_INV_CHECK;
  SAVE_STACK_INV();
  foo();
  CHECK_STACK_INV();
  fprintf(st_errout, "6 st_main finished\n");
  fprintf(st_errout, "7 OK\n");
  return 0;
}
