/* 
 * steal.c --- a simple work stealing test
 */

#include <stdio.h>
#include <st.h>

void foo(st_join_counter_t * c, st_join_counter_t * d)
{
  DECLARE_STACK_INV_CHECK;
  /* wait a second to make sure the other worker already start */
  printf("%d : sleep a second\n", tls(worker_id));
  st_sleep_os_thread_ms(1000);
  printf("%d : woke up\n", tls(worker_id));
  /* this should give 'st_main' to another worker */

#if 0
  st_print_stack_and_contexts("before");
#endif

  SAVE_STACK_INV();
  st_assert(tls(worker_cell)->msg);
  st_assert(tls(worker_cell)->msg->k == wmk_task_steal_request);
  st_respond_to_worker_msg_user(0);
  CHECK_STACK_INV();

#if 0
  st_print_stack_and_contexts("after");
#endif

  if (tls(worker_id) == 0) {
    fprintf(st_errout, "thread %d executes foo\n", tls(worker_id));
  }
  SAVE_STACK_INV();
  st_join_counter_wait(c);
  CHECK_STACK_INV();
  SAVE_STACK_INV();
  st_join_counter_finish(d);
  CHECK_STACK_INV();
}

int st_main(int argc, char ** argv)
{
  DECLARE_STACK_INV_CHECK;
  st_join_counter_t c[1];
  st_join_counter_t d[1];

  st_join_counter_init(c, 1);
  st_join_counter_init(d, 1);
  
  if (tls(gopts)->n_workers != 2 || tls(gopts)->steal_wait_limit != -1) {
    fprintf(st_errout, "run this program with -nw 2 -sl -1\n");
    fprintf(st_errout, "%s -nw 2 -sl -1\n", argv[0]);
    st_wg_exit((void *)1);
  }
  
  if (tls(worker_id) != 0) {
    fprintf(st_errout, 
	    "something is wrong: my worker id should be 0 (is now %d)\n",
	    tls(worker_id));
  }
  
  SAVE_STACK_INV();
  ST_THREAD_CREATE(foo(c, d));
  CHECK_STACK_INV();
  
  if (tls(worker_id) != 1) {
    fprintf(st_errout, 
	    "%d : task stealing did not occur during foo\n"
	    "something will (probably) be wrong\n", tls(worker_id));
  }

  fprintf(st_errout, "thread %d executes the rest of main\n", tls(worker_id));

  SAVE_STACK_INV();
  st_join_counter_finish(c);
  CHECK_STACK_INV();

  if (tls(worker_id) != 1) {
    fprintf(st_errout, "%d : something wrong\n", tls(worker_id));
  }

  SAVE_STACK_INV();
  st_join_counter_wait(d);
  CHECK_STACK_INV();

  fprintf(st_errout, "OK\n");
  return 0;
}

