/* 
 * steal.c --- a simple work stealing test
 */

#include <stdio.h>
#include <st.h>

void bar()
{
  DECLARE_STACK_INV_CHECK;
  fprintf(st_errout, "%d : bar\n", tls(worker_id));
  /* approximate time 0: wait for thread 1 to try to steal a task */
  st_sleep_os_thread_ms(1000);
  /* approximate time 1 */
  SAVE_STACK_INV();
  fprintf(st_errout, "%d : give foo to worker 1\n", tls(worker_id));
  st_assert(tls(worker_cell)->msg);
  st_assert(tls(worker_cell)->msg->k == wmk_task_steal_request);
  st_assert(tls(n_total_threads) == 3);
  /* foo will be stolen below, */
  st_respond_to_worker_msg_user(1);
  /* so we have two threads here */
  st_assert(tls(n_total_threads) == 2);
  CHECK_STACK_INV();
  
  /* approximate time 1: wait for thread 1 to return to foo */
  fprintf(st_errout, 
	  "%d : sleep a second waiting for worker 1 to finish foo\n",
	  tls(worker_id));
  st_sleep_os_thread_ms(1000);
  /* approximate time 2 */

  /* this must clean up stack (bar must be exposed as the top frame) */
  ST_POLLING();
  st_assert(asm_get_fp() == tls(fixed_watermark));
}

#define N 100
void foo()
{
  int a[N];
  int i;
  DECLARE_STACK_INV_CHECK;

  fprintf(st_errout, "%d : foo\n", tls(worker_id));
  for(i = 0; i < N; i++) a[i] = -i;

  st_assert(tls(n_total_threads) == 2);
  ST_THREAD_CREATE(bar());

  if (tls(worker_id) == 1) {
    fprintf(st_errout, "%d : executes the rest of foo\n", tls(worker_id));
  }

  /* approximate time 1: wait for the thread 0 to return to main. */
  fprintf(st_errout, 
	  "%d : sleep 3 seconds to wait for the worker 0 to finish main\n", 
	  tls(worker_id));
  st_sleep_os_thread_ms(3000);
  printf("%d : woke up\n", tls(worker_id));
  /* approximate time 4: */

  for (i = 0; i < N; i++) {
    if (a[i] != -i) {
      fprintf(st_errout, "%d : a[%d] = %d != %d\n", i, a[i], -i);
      st_wg_exit((void *)1);
    }
  }

  fprintf(st_errout, "%d : OK\n", tls(worker_id));
}

int baz(int, int, int, int, int, int, int, int, int, int,
	int, int, int, int, int, int, int, int, int, int,
	int, int, int, int, int, int, int, int, int, int);

int st_main(int argc, char ** argv)
{
  DECLARE_STACK_INV_CHECK;
  
  if (tls(gopts)->n_workers != 2 || tls(gopts)->steal_wait_limit != -1) {
    fprintf(st_errout, "run this program with -nw 2 -sl -1\n");
    fprintf(st_errout, "%s -nw 2 -sl -1\n", argv[0]);
    st_wg_exit((void *)1);
  }
  
  if (tls(worker_id) != 0) {
    fprintf(st_errout, 
	    "something is wrong: my thread id should be 0 (is now %d)\n",
	    tls(worker_id));
  }
  
  SAVE_STACK_INV();
  st_assert(tls(n_total_threads) == 1);
  ST_THREAD_CREATE(foo());
  /* at this point, bar has been stolen and foo has finished, so the number
     of threads must be 1 */
  st_assert(tls(n_total_threads) == 1);
  CHECK_STACK_INV();
  
  if (tls(worker_id) != 0) {
    fprintf(st_errout, 
	    "(thread_id == %d) task stealing did not occur during foo\n"
	    "something will (probably) be wrong\n", tls(worker_id));
  }

  if (tls(thread_id) != 0) {
    fprintf(st_errout, "something is wrong (thread %d)\n", tls(thread_id));
  }

  fprintf(st_errout, "%d : executes the rest of main\n", tls(worker_id));

  baz(100, 200, 300, 400, 500, 600, 700, 800, 900, 1000, 
      1100, 1200, 1300, 1400, 1500, 1600, 1700, 1800, 1900, 2000, 
      2100, 2200, 2300, 2400, 2500, 2600, 2700, 2800, 2900, 3000);

  fprintf(st_errout, "%d : OK\n", tls(worker_id));
  return 0;
}

int baz(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10,
	 a11, a12, a13, a14, a15, a16, a17, a18, a19, a20,
	 a21, a22, a23, a24, a25, a26, a27, a28, a29, a30)
     int a1, a2, a3, a4, a5, a6, a7, a8, a9, a10,
  a11, a12, a13, a14, a15, a16, a17, a18, a19, a20,
  a21, a22, a23, a24, a25, a26, a27, a28, a29, a30;
{
  return 0;
}
