/* 
 * strpass.c 
 */

#include <st.h>

st_context_t foo_con = 0;

typedef struct point
{
  int x, y;
} point;

typedef struct point2
{
  int x, y;
} point2;

int struct_arg_corrupted = 0;

void foo(point p)
{
  DECLARE_STACK_INV_CHECK;
  struct st_context c[1];
  c->valid = 0;
  foo_con = c;
  fprintf(st_errout, "2 : foo blocks\n");
  SAVE_STACK_INV();
  st_suspend_thread_n(c, 1);
  CHECK_STACK_INV();
  fprintf(st_errout, "4 : foo restarted and finishes\n");
  if (p.x != 123 || p.y != 456) {
    struct_arg_corrupted = 1;
    fprintf(st_errout, 
	    "*************************************************************\n"
	    "Structure argument to ST_THREAD_CREATE(foo(p)) is corrupted.\n"
	    "This is a known problem on SPARC.\n"
	    "You may either patch gcc to fix this problem (see manual),\n"
	    "or just avoid passing struct args to procedure calls with "
	    "ST_THREAD_CRREATE\n"
	    "*************************************************************\n");
    st_wg_exit((void *)1);
  }
  foo_con = 0;
}

void bar(point2 q)
{
  
}

int st_main()
{
  point p;
  point2 q;
  struct invalid_frame_desc iff[1];
  DECLARE_STACK_INV_CHECK;
  fprintf(st_errout, "1 : st_main forks foo\n");
  SAVE_STACK_INV();
  p.x = 123; p.y = 456;
  ST_THREAD_CREATE(foo(p));
  CHECK_STACK_INV();
  fprintf(st_errout, "3 : foo blocked, restart foo\n");
  /* this will corrupt {123, 456} passed to foo  */
  q.x = 789; q.y = 789;
  bar(q);
  st_assert(foo_con);
  SAVE_STACK_INV();
  INVALID_CALL(st_restart_context_n(foo_con, iff, 1));
  CHECK_STACK_INV();
  fprintf(st_errout, "5 : foo finished\n");
  st_assert(foo_con == 0);
  if (struct_arg_corrupted) {
    fprintf(st_errout, "6 : Structure arguments may be corrupted\n");
  } else {
    fprintf(st_errout, "6 : OK\n");
  }
  return 0;
}
