/* 
 * susp.c --- the simplest test for suspension and restarting
 */

#include <st.h>

st_context_t foo_con = 0;

void foo(void);

void foo(void)
{
  DECLARE_STACK_INV_CHECK;
  struct st_context c[1];
  c->valid = 0;
  foo_con = c;
  fprintf(st_errout, "2 : foo blocks\n");
  SAVE_STACK_INV();
  st_suspend_thread_n(c, 1);
  CHECK_STACK_INV();
  fprintf(st_errout, "4 : foo restarted and finishes\n");
  foo_con = 0;
}

int st_main()
{
  struct invalid_frame_desc iff[1];
  DECLARE_STACK_INV_CHECK;
  fprintf(st_errout, "1 : st_main forks foo\n");
  SAVE_STACK_INV();
  ST_THREAD_CREATE(foo());
  CHECK_STACK_INV();
  fprintf(st_errout, "3 : foo blocked, restart foo\n");
  st_assert(foo_con);
  SAVE_STACK_INV();
  INVALID_CALL(st_restart_context_n(foo_con, iff, 1));
  CHECK_STACK_INV();
  fprintf(st_errout, "5 : foo finished\n");
  st_assert(foo_con == 0);
  fprintf(st_errout, "6 : OK\n");
  return 0;
}
