#include <st.h>
#include <smllc.h>

/* 
 * Copyright (c) 1999 by Kenjiro Taura, Akinori Yonezawa. All rights reserved.
 * Copyright (c) 1999 by Yoshihiro Oyama, Toshio Endo. All rights reserved.
 * Copyright (c) 1999 by Kunio Tabata. All rights reserved.
 * Copyright (c) 1999 by Mitsubishi Research Institute.  All rights reserved.
 * Copyright (c) 1999 by Information-technology Promotion Agency.  All rights reserved.
 *
 * THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
 * OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
 *
 * Permission is hereby granted to use or copy this program
 * for any purpose,  provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */

#define PUBLIC 
#define GLOBAL
#define PRIVATE static

/*
  If you want to smalloc as fast as possible, Uncoment the followings and
  Compile this file with the --no_postprocess.
*/
/*
  #ifndef STHREADS_NOPP
  #warning "This file is recommended to be compiled with --no_postprocess"
  #endif
 */

#define ALIGNMENT 8
#define LOCAL_CHUNK 1 * 1024 * 1024
#define MIN_MALLOC_SIZE 8 
#define INTERNAL_THRESHOLD 4096
#define INTERNAL_THRESHOLD_INDEX 9

#define PUBLIC 
#define GLOBAL
#define PRIVATE static
/* align for sparc */
/* pending... i have to make it for a variety of architechture */
PRIVATE size_t align(size_t size){
  if(size % ALIGNMENT)
    return size + ALIGNMENT - (size % ALIGNMENT);
  else
    return size;
}

/* st original heap management for smalloc */
typedef struct free_info
{
  int index;
  struct free_info *next;
} * free_info_t;

void allocate_new_page(void){
  tls(pool_begin) = (char *)smalloc_fixed(LOCAL_CHUNK);
  tls(pool_end) = tls(pool_begin) + LOCAL_CHUNK; 
}

void smalloc_internal_init(int nw){
  return;
}

void sthreads2_worker_start_hook_smalloc_internal_init_local(void){
  int i;
  /* prefetch some */
  allocate_new_page();
  /* nullfy free_list */
  for(i = 0; i< 9; i++)
    tls(tl_free_list)[i] = 0;
}

#define SPEED_UP_CILK_APPS
#ifdef SPEED_UP_CILK_APPS
#  define EXTRA_SIZE 64
#else
#  define EXTRA_SIZE 8
#endif

void *smalloc_internal(size_t size){
  int i, index = 0;
  struct free_info *allocated;
  size_t rdsize;

  /* check threashold */
  if(size>INTERNAL_THRESHOLD + EXTRA_SIZE) return smalloc(size);

  /* round up */
  for(i = MIN_MALLOC_SIZE; i + EXTRA_SIZE < size + sizeof(struct free_info); i <<= 1)
    index++;
  rdsize = align(i);
  
  /* check free list */
  if(tls(tl_free_list)[index]){
    assert(tls(tl_free_list)[index]->index == index);
    /* get from free list */
    allocated = tls(tl_free_list)[index];
    tls(tl_free_list)[index] = tls(tl_free_list)[index]->next;
  } else {
    /* get an area from local heap area */
    if(tls(pool_begin) + rdsize + EXTRA_SIZE >  tls(pool_end)){
      allocate_new_page();
    }
    allocated = tls(pool_begin);
    allocated -> index = index;
    tls(pool_begin) += rdsize + EXTRA_SIZE;
  }

  /* hide free_info */
  allocated ++;

  /* return */
  return allocated;
}
 
void sfree_internal(void *p){ 
  int i;

  /* slide */
  struct free_info *head = (struct free_info *)p - 1;

  /* call sfree for the big size */
  if(head->index > INTERNAL_THRESHOLD_INDEX){
    sfree( head );
    return;
  }
  
  /* attach_free_list */
  head->next = tls(tl_free_list)[head->index];
  tls(tl_free_list)[head->index] = head;

  /* We might have to return something special ? */
  return;
}
