/* 
 * st_mm.c
 */


/* 
 * Copyright (c) 1999 by Kenjiro Taura, Akinori Yonezawa. All rights reserved.
 * Copyright (c) 1999 by Yoshihiro Oyama, Toshio Endo. All rights reserved.
 * Copyright (c) 1999 by Kunio Tabata. All rights reserved.
 * Copyright (c) 1999 by Mitsubishi Research Institute.  All rights reserved.
 * Copyright (c) 1999 by Information-technology Promotion Agency.  All rights reserved.
 *
 * THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
 * OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
 *
 * Permission is hereby granted to use or copy this program
 * for any purpose,  provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */

#if WITH_SGC
#include <sgc.h>
#endif

/* set zero to this when you want to avoid checks */
#define MAKE_SURE_DONT_GC 1

void mm_noop(void * ptr)
{
  
}

#if WITH_SGC

void * GC_malloc_ignore_off_page_make_sure_dont_gc(size_t sz)
{
#if MAKE_SURE_DONT_GC
  if (GC_dont_gc == 0) GC_dont_gc = 1;
#endif MAKE_SURE_DONT_GC
  return GC_malloc_ignore_off_page(sz);
}

void * GC_malloc_atomic_ignore_off_page_make_sure_dont_gc(size_t sz)
{
#if MAKE_SURE_DONT_GC
  if (GC_dont_gc == 0) GC_dont_gc = 1;
#endif MAKE_SURE_DONT_GC
  return GC_malloc_atomic_ignore_off_page(sz);
}

#endif /* WITH_SGC */
