/* 
 * sc.h
 */

/* 
 * Copyright (c) 1999 by Kenjiro Taura, Akinori Yonezawa. All rights reserved.
 * Copyright (c) 1999 by Yoshihiro Oyama, Toshio Endo. All rights reserved.
 * Copyright (c) 1999 by Kunio Tabata. All rights reserved.
 * Copyright (c) 1999 by Mitsubishi Research Institute.  All rights reserved.
 * Copyright (c) 1999 by Information-technology Promotion Agency.  All rights reserved.
 *
 * THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
 * OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
 *
 * Permission is hereby granted to use or copy this program
 * for any purpose,  provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */

#ifndef __CILKCNT_H__
#define __CILKCNT_H__

#ifdef __cplusplus
extern "C" {
#endif

/* single read counter */
typedef struct cilk_sync_counter
{
  int waiter_stolen;
  st_context_t waiting;
  st_int_loc_t n_finished;
  int n_spawned;
} cilk_sync_counter, *cilk_sync_counter_t;

void init_cilk_sync_counter(cilk_sync_counter_t, uslong);
void cilk_sync_counter_finish(cilk_sync_counter_t c);
int cilk_sync_counter_lock(cilk_sync_counter_t c);
void cilk_sync_counter_finish_and_unlock(cilk_sync_counter_t c, int old_count);
void cilk_sync_counter_spawn(cilk_sync_counter_t c);
void cilk_sync_counter_wait(cilk_sync_counter_t c);

#if 0
void cilk_sync_counter_add(void *,int,cilk_sync_counter_t);
#endif

#define csc cilk_sync_counter
#define csc_t cilk_sync_counter_t
#define init_csc(c, x) init_cilk_sync_counter(c, x)
#define csc_spawn(c) cilk_sync_counter_spawn(c)
#define csc_finish(c) cilk_sync_counter_finish(c)
#define csc_lock(c) cilk_sync_counter_lock(c)
#define csc_finish_and_unlock(c, oc) cilk_sync_counter_finish_and_unlock(c, oc)
#define csc_wait(c) cilk_sync_counter_wait(c)

#define inl_init_csc(c, v) \
do { \
  c->waiting = 0; \
  c->waiter_stolen = 0; \
  ST_INT_LOC_INIT(&c->n_finished, 0); \
  c->n_spawned = v; \
} while(0)

#define inl_csc_spawn(c) c->n_spawned++

#define inl_csc_finish(c) \
do { \
  if (c->waiter_stolen == 0) \
    c->n_finished.v \
      = ST_INT_LOC_ATTATCH_TAG(ST_INT_LOC_STRIP_TAG(c->n_finished.v) + 1); \
  else csc_finish(c); \
} while(0)

#define inl_csc_add_finish(c, r, x, TYPE) \
do{ \
  if (c->waiter_stolen == 0) { \
    *(TYPE *)r += x; \
    c->n_finished.v \
      = ST_INT_LOC_ATTATCH_TAG(ST_INT_LOC_STRIP_TAG(c->n_finished.v) + 1); \
  } else { \
    int _oc = st_read_and_lock_int(&c->n_finished); \
    *(TYPE *)r += x; \
    csc_finish_and_unlock(c, _oc); \
  } \
}while(0)

#define inl_csc_wait(c) \
do { \
  if(c->waiter_stolen) csc_wait(c); \
} while(0)

#ifdef __cplusplus
}
#endif

#endif /* __CILKCNT_H__ */
