/* 
 * edg_gcc.h --- header file to make EDG behave like GCC. 
 */

/* 
 * Copyright (c) 1999 by Kenjiro Taura, Akinori Yonezawa. All rights reserved.
 * Copyright (c) 1999 by Yoshihiro Oyama, Toshio Endo. All rights reserved.
 * Copyright (c) 1999 by Kunio Tabata. All rights reserved.
 * Copyright (c) 1999 by Mitsubishi Research Institute.  All rights reserved.
 * Copyright (c) 1999 by Information-technology Promotion Agency.  All rights reserved.
 *
 * THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
 * OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
 *
 * Permission is hereby granted to use or copy this program
 * for any purpose,  provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */

/* necessary because some GNU header files use long long */
#define _NO_LONGLONG

/* define __SIZE_TYPE__ here to avoid warnings.
   gcc has a built-in definition for that (as unsigned int), but EDG deos not.

   When EDG processes a program that includes "stdlib.h", stdlib.h
   defines __SIZE_TYPE__ as unsingd long
   (/usr/local/lib/gcc-lib/sparc-sun-solaris2.5.1/2.7.2.1/include/stdlib.h:line 36--42). This is incompatible with (1) what EDG expects and (2) gcc
   (more precisely, gcc's built-in definition for memcpy and friends)
   expects. Both expect it as unsinged int. 

   Without definition of __SIZE_TYPE__ here, the net result is, (1)
   when EDG processes a program that includes stdlib.h, EDG issues a
   warning that says size_t is incompatible with its expectation, and
   (2) when gcc compiles a EDG-generated C program, whose original C 
   source includes both stdlib.h and string.h, gcc issues a warning
   that says declarations of memcpy and friends (in string.h) are 
   incompatible with gcc's built-in definition. */
#define __SIZE_TYPE__ unsigned int

