/* 
 * falloc.h
 */

/* 
 * Copyright (c) 1999 by Kenjiro Taura, Akinori Yonezawa. All rights reserved.
 * Copyright (c) 1999 by Yoshihiro Oyama, Toshio Endo. All rights reserved.
 * Copyright (c) 1999 by Kunio Tabata. All rights reserved.
 * Copyright (c) 1999 by Mitsubishi Research Institute.  All rights reserved.
 * Copyright (c) 1999 by Information-technology Promotion Agency.  All rights reserved.
 *
 * THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
 * OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
 *
 * Permission is hereby granted to use or copy this program
 * for any purpose,  provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */

#ifndef __FALLOC_H__
#define __FALLOC_H__

#ifdef __cplusplus
extern "C" {
#endif

typedef struct local_falloc_info
{
    long _generation;
    uslong _falloc_pointer;
    uslong _falloc_limit;

    /* pointer to current page from which allocation requests are served */
    void * _current_page;

    /* the head of free list of my falloc pages.
       persistent across multiple reset_my_heap. */
    void * _falloc_head;
#if 1 || defined(FALLOC_DBG)
    int _n_allocated_pages;
#endif
} * local_falloc_info_t;

typedef struct global_falloc_info
{
    long _generation;
    int _init_falloc_local_called;
    long _underlying_malloc_lock;
} * global_falloc_info_t;
extern struct global_falloc_info __gfi;
#define global_generation __gfi._generation
#define init_falloc_local_called __gfi._init_falloc_local_called
#define underlying_malloc_lock __gfi._underlying_malloc_lock

/* these macros should be used in the context where a variable __h
   is defined as follows:
   local_falloc_info_t __hi = *(local_falloc_info_t*)(tls_user); */
#define USE_FALLOC_LOCAL local_falloc_info_t __hi = *(local_falloc_info_t*)(tls_user)
#define my_generation __hi->_generation
#define my_falloc_pointer __hi->_falloc_pointer
#define my_falloc_limit __hi->_falloc_limit
#define my_current_page __hi->_current_page
#define my_falloc_head __hi->_falloc_head
#if 1 || defined(FALLOC_DBG)
#define my_n_allocated_pages __hi->_n_allocated_pages
#endif

/* initialize fast alloc.
   should be done before any allocation heappens */
void init_falloc(void);
/* begin self heap management */
void reset_falloc_heap (void);
/* objects on self managed heap are discarded */
void end_falloc (void);
/* allocation */
void * falloc(int);

void sthreads2_worker_start_hook_init_falloc_local(void);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __FALLOC_H__ */

