/* 
 * istr.h
 */

/* 
 * Copyright (c) 1999 by Kenjiro Taura, Akinori Yonezawa. All rights reserved.
 * Copyright (c) 1999 by Yoshihiro Oyama, Toshio Endo. All rights reserved.
 * Copyright (c) 1999 by Kunio Tabata. All rights reserved.
 * Copyright (c) 1999 by Mitsubishi Research Institute.  All rights reserved.
 * Copyright (c) 1999 by Information-technology Promotion Agency.  All rights reserved.
 *
 * THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
 * OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
 *
 * Permission is hereby granted to use or copy this program
 * for any purpose,  provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */

#ifndef __ISTR_H__
#define __ISTR_H__

#include <stdio.h>

/* write once, read many */
template<class T>
struct istr
{
  T val;
  list_t(st_context_t) waiters;
  istr() {
    waiters = 0;
  }
  void clear() {
    waiters = 0;
  }
  void clear(T v) {
    waiters = 0;
    val = v;
  }
  
  T get() {
    if((unsigned long)waiters == 1) {
      /* the value is there */
      MEMBAR_READ_READ();
      return val;
    } else {
#ifdef ISTR_NEVER_FAIL
      fprintf(st_errout, "error: istr::get before istr::put (%x)\n", this);
      st_error();
#else  /* ISTR_NEVER_FAIL */
      list_t(st_context_t) ws 
	= (list_t(st_context_t))st_spin_lock((long*)&waiters);
      if ((unsigned long)ws == 1) {
	waiters = (list_t(st_context_t))1; /* unlock */
	MEMBAR_READ_READ();
	return val;
      } else {
	/* value is not there. suspend */
	struct st_context c[1];
	c->valid = 0;
#ifdef USE_FALLOC
	waiters = fast_cons(c, ws); /* unlock */
#else
	waiters = cons(c, ws);	/* unlock */
#endif
	st_suspend_thread_n(c, 1);
	return val;
      }
#endif /* ISTR_NEVER_FAIL */
    }
  }

  void wakeup_all(list_t(st_context_t) w) {
      if (w) {
	  wakeup_all(w->cdr); /* extend stack first */
#if ISTR_WAKEUP_IMMEDIATELY
	  struct invalid_frame_desc iff[1];
	  INVALID_PROC_FORK_X(st_restart_context_n(w->car, iff, 1), iff);
#else  /* ISTR_WAKEUP_IMMEDIATELY */
	  st_resume_context(w->car);
#endif /* ISTR_WAKEUP_IMMEDIATELY */
      }
  }

  void put(T v) {
    list_t(st_context_t) ws 
      = (list_t(st_context_t))st_spin_lock((long*)&waiters);
    if (ws == 0) {
      val = v;
      MEMBAR_WRITE_WRITE();
      waiters = (list_t(st_context_t))1; /* unlock */
    } else if ((unsigned long) ws == 1) {
      waiters = ws;		/* unlock */
      fprintf(st_errout, "multiple writes to istructure %x\n", this);
      st_app_exit(1);
    } else {			/* there are some waiters */
#ifdef ISTR_NEVER_FAIL
      fprintf(st_errout, "error: a thread is waiting on istr %x\n"
	      "probably corrupted or uninitialized istructure\n", this);
      st_error();
#else  /* ISTR_NEVER_FAIL */
      val = v;
      MEMBAR_WRITE_WRITE();
      waiters = (list_t(st_context_t))1; /* unlock */
      ST_THREAD_CREATE(wakeup_all(ws));
#endif /* ISTR_NEVER_FAIL */
    }
  }
};

#endif /* __ISTR_H__ */

