/* 
 * st_foreign.h 
 */

/* 
 * Copyright (c) 1999 by Kenjiro Taura, Akinori Yonezawa. All rights reserved.
 * Copyright (c) 1999 by Yoshihiro Oyama, Toshio Endo. All rights reserved.
 * Copyright (c) 1999 by Kunio Tabata. All rights reserved.
 * Copyright (c) 1999 by Mitsubishi Research Institute.  All rights reserved.
 * Copyright (c) 1999 by Information-technology Promotion Agency.  All rights reserved.
 *
 * THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
 * OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
 *
 * Permission is hereby granted to use or copy this program
 * for any purpose,  provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */

#ifndef __ST_FOREIGN_H__
#define __ST_FOREIGN_H__

#ifdef __cplusplus
extern "C" {
#endif

/* timing profile */

typedef struct st_prof_conf
{
  int do_profile;		/* 1 if we profile the entire life time of
				   the worker group */
  int resolution;		/* resolution of profile */
  int max_intervals;		/* size of the in-memory records */
  char * filename_prefix;	/* filename */
} * st_prof_conf_t;

/* worker group configuration */
typedef struct worker_group_conf
{
  /* 1 if we should print statistics of the worker group */
  int print_stat;
  /* profile configuration */
  struct st_prof_conf prof_conf;
} * worker_group_conf_t;

int stf_init_worker_group_conf(worker_group_conf_t);
int stf_worker_group_conf_set_print_stat(worker_group_conf_t, int);
int stf_worker_group_conf_set_prof_do_profile(worker_group_conf_t, int);
int stf_worker_group_conf_set_prof_resolution(worker_group_conf_t, int);
int stf_worker_group_conf_set_prof_buffer_size(worker_group_conf_t, int);
int stf_worker_group_conf_set_prof_filename(worker_group_conf_t, char *);

int stf_worker_group_conf_get_print_stat(worker_group_conf_t);
int stf_worker_group_conf_get_prof_do_profile(worker_group_conf_t);
int stf_worker_group_conf_get_prof_resolution(worker_group_conf_t);
int stf_worker_group_conf_get_prof_buffer_size(worker_group_conf_t);
char * stf_worker_group_conf_get_prof_filename(worker_group_conf_t);

#if defined(WORKER_PROC_N_PARAMS) && (WORKER_PROC_N_PARAMS != 4)
#error change this file accordingly when you change WORKER_PROC_N_PARAMS
#endif
typedef void * (*worker_proc_t)(void *, void *, void *, void *);
typedef struct worker_group * worker_group_t;

void * 
stf_create_sync_worker_group(worker_group_conf_t, /* configuration */
			     int /* initial number of workers */,
			     worker_proc_t f, 
			     void *, void *, void *, void *);

/* create a group of workers that performs f(a0, a1, a2, a3).
   dont wait for completion */

void 
stf_create_async_worker_group(struct worker_group * /* wg */, 
			      worker_group_conf_t, /* configuration */
			      int /* initial number of workers */,
			      worker_proc_t f,
			      void *, void *, void *, void *);

void * stf_wait_for_wg_to_exit(worker_group_t);
int stf_did_wg_exit(worker_group_t);

void stf_sgc_init(int);
void stf_sgc_finalize(void);

void * st_init_tss(void);
int st_dont_postprocess(void);

#define FOREIGN_IF_BEGIN() \
  void * __t = st_init_tss(); \
  int ___ = st_dont_postprocess() \

#define FOREIGN_IF_END() st_restore_tls(__t)

#define ST_CALLBACK_BEGIN() FOREIGN_IF_BEGIN()
#define ST_CALLBACK_END() FOREIGN_IF_END()

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __ST_FOREIGN_H__ */
