/* 
 * st_list.h
 */

/* 
 * Copyright (c) 1999 by Kenjiro Taura, Akinori Yonezawa. All rights reserved.
 * Copyright (c) 1999 by Yoshihiro Oyama, Toshio Endo. All rights reserved.
 * Copyright (c) 1999 by Kunio Tabata. All rights reserved.
 * Copyright (c) 1999 by Mitsubishi Research Institute.  All rights reserved.
 * Copyright (c) 1999 by Information-technology Promotion Agency.  All rights reserved.
 *
 * THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
 * OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
 *
 * Permission is hereby granted to use or copy this program
 * for any purpose,  provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */

#ifndef __ST_LIST_H__
#define __ST_LIST_H__

#include <st_mm.h>

template<class T>
struct st_list : st_mm
{
  st_list (T a, st_list<T>* d) { car = a; cdr = d; }
  T car;
  st_list<T> * cdr;
};
#define st_list_t(T) st_list<T>*

template<class T>
inline static st_list_t(T) cons (T a, st_list_t(T) d)
{
  st_list_t(T) c;
  c = new st_list<T> (a, d);
  return c;
}

#if UNDERLYING_MM_IS_SGC
/* cons with an explicit placement */
template<class T>
inline static st_list_t(T) cons (T a, st_list_t(T) d, mm_obj_kind k)
{
  st_list_t(T) c;
  c = new (k) st_list<T> (a, d);
  return c;
}
#endif /* UNDERLYING_MM_IS_SGC */

/* cons with an explicit region */
template<class T>
inline static st_list_t(T) cons (T a, st_list_t(T) d, st_region_t rg)
{
  st_list_t(T) c;
  c = new (rg) st_list<T> (a, d);
  return c;
}

template<class T>
static st_list_t(T) reverse (st_list_t(T) l)
{
  st_list_t(T) r = 0;
  while (l) {
    r = cons (l->car, r);
    l = l->cdr;
  }
  return r;
}

#if UNDERLYING_MM_IS_SGC
template<class T>
static st_list_t(T) reverse (st_list_t(T) l, mm_obj_kind k)
{
  st_list_t(T) r = 0;
  while (l) {
    r = cons (l->car, r, k);
    l = l->cdr;
  }
  return r;
}
#endif /* UNDERLYING_MM_IS_SGC */

template<class T>
static st_list_t(T) reverse (st_list_t(T) l, st_region_t rg)
{
  st_list_t(T) r = 0;
  while (l) {
    r = cons (l->car, r, rg);
    l = l->cdr;
  }
  return r;
}

template<class T>
static int length (st_list_t(T) l)
{
  int r = 0;
  while (l) {
    r++;
    l = l->cdr;
  }
  return r;
}

/*
 * push all elements in X in front of Y.
 * do as much conses as the length of X. do not update cells
 * in place.
 */

template<class T>
static st_list_t(T) rev_append (st_list_t(T) X, st_list_t(T) Y)
{
  for (st_list_t(T) p = X; p; p = p->cdr) Y = cons (p->car, Y);
  return Y;
}

#if UNDERLYING_MM_IS_SGC
template<class T>
static st_list_t(T) rev_append (st_list_t(T) X, st_list_t(T) Y, mm_obj_kind k)
{
  for (st_list_t(T) p = X; p; p = p->cdr) Y = cons (p->car, Y, k);
  return Y;
}
#endif /* UNDERLYING_MM_IS_SGC */

template<class T>
static st_list_t(T) rev_append (st_list_t(T) X, st_list_t(T) Y, st_region_t rg)
{
  for (st_list_t(T) p = X; p; p = p->cdr) Y = cons (p->car, Y, rg);
  return Y;
}

/*
 * append two st_lists destructively.
 */

template<class T>
static st_list_t(T) nconc (st_list_t(T) X, st_list_t(T) Y)
{
  if (X) {
    st_list_t(T) p = X;
    while (p->cdr) p = p->cdr;
    /* here p->cdr == 0, but p != 0 */
    p->cdr = Y;
    return X;
  } else {
    return Y;
  }
}

/* apply f to each element in X */
template<class T>
static void st_list_for_each (void (*f)(T), st_list_t(T) X)
{
  st_list_t(T) p;
  for (p = X; p; p = p->cdr) {
    f(p->car);
  }
}

#endif /* __ST_LIST_H__ */

