/* 
 * st_thrcrt.h --- ST_THREAD_CREATE and auxiliary macros
 */

/* 
 * Copyright (c) 1999 by Kenjiro Taura, Akinori Yonezawa. All rights reserved.
 * Copyright (c) 1999 by Yoshihiro Oyama, Toshio Endo. All rights reserved.
 * Copyright (c) 1999 by Kunio Tabata. All rights reserved.
 * Copyright (c) 1999 by Mitsubishi Research Institute.  All rights reserved.
 * Copyright (c) 1999 by Information-technology Promotion Agency.  All rights reserved.
 *
 * THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
 * OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
 *
 * Permission is hereby granted to use or copy this program
 * for any purpose,  provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */

#ifndef __ST_THRCRT_H__
#define __ST_THRCRT_H__

#ifdef __GNUC__
#define GCC_EXT(x) x
#else
#define GCC_EXT(x)
#endif

/* this information is here only because they are used by output from
   EDG frontend. this is in turn because they are referenced a line after
   #pragma gccext (uslong fixed_cs_regs[CALLEE_SAVES_N_WORDS] ...) etc.
   
   They must eventually go away, when we extend EDG so that it handles
   gcc-specific extensions in a better way. 

   NOTE: these definitions are duplicated in st.h */
#if defined(i386)
#define CALLEE_SAVES_N_WORDS 2
#define TLS_REG_NAME ("ebx")
#define CS_ASSUMES_DW_ALIGNED 0
#elif defined(mips)
#define CALLEE_SAVES_N_WORDS 19
#define TLS_REG_NAME ("$23")
#define CS_ASSUMES_DW_ALIGNED 1
#elif defined(__sparc)
#define CALLEE_SAVES_N_WORDS 13
#define TLS_REG_NAME ("%l7")
#define CS_ASSUMES_DW_ALIGNED 1
#elif defined(__alpha)
#define CALLEE_SAVES_N_WORDS 13
#define TLS_REG_NAME ("$14")
#define CS_ASSUMES_DW_ALIGNED 1
#else
#error "unknown CPU"
#endif

#if CS_ASSUMES_DW_ALIGNED
#define CS_ALIGN_REQUEST __attribute__ ((aligned (8)))
#else
#define CS_ALIGN_REQUEST 
#endif  
/* things above must eventually go away */


/* things below are right members of this file */
#if ST_STAT
#define THR_STAT_INC(x) tls(thread_stat).x++
#define THR_STAT_DEC(x) tls(thread_stat).x--
#else  /* ST_STAT */
#define THR_STAT_INC(x) do { } while(0)
#define THR_STAT_DEC(x) do { } while(0)
#endif /* ST_STAT */

#define tls(x) __tls->_##x
#define tls_user ((void*)(tls(user)))

#if ST_DBG
#define CHECK_TSS_INIT() \
do { if(!ST_INT_LOC_CHECK(&__tss_init_state, tss_init_state_inited)) tss_init_error(); } while(0)
#else
#define CHECK_TSS_INIT() \
do { } while(0)
#endif

#define ASYNC_CALL(EXP) \
do { \
  __st_fork_block_start(); \
  EXP; \
  __st_fork_block_end(); \
} while(0)

#define ASYNC_CALL0(EXP) \
do { \
  __st_fork_block_start0(); \
  EXP; \
  __st_fork_block_end0(); \
} while(0)

#define INVALID_CALL(EXP) \
do { \
  __st_invalid_call_start(); \
  EXP; \
  __st_invalid_call_end(); \
  asm_fix_callee_saves(); \
  tls(fixed_invalid_frames) = tls(fixed_invalid_frames)->next; \
} while(0) 


#define FORK_POINT_X(iff) \
do { \
  if (tls(thread_blocked)) { \
    if (tls(task_steal_context)) { /* receive steal request */ \
      if (tls(you_should_be_stolen)) { /* this frame will be given */ \
        THREAD_STOLEN_HOOK(); \
	st_give_this_thread(); /* unwind one more frame */ \
	break; \
      } else { /* the frame above this frame has been stolen */ \
        THREAD_CHILD_STOLEN_HOOK(); \
	ASYNC_CALL0(INVALID_CALL(st_child_was_given(iff))); \
	continue; \
      } \
    } else { /* block (not steal) */ \
      THR_STAT_INC(n_blocks); \
      tls(thread_blocked) = 0; \
      THREAD_BLOCKED_HOOK(); \
      break; \
    } \
  } else { /* normal thread finish */ \
    tls(n_total_threads)--; \
    break; \
  } \
} while (1)

#define PROC_FORK_X(EXP, iff) \
do { \
  tls(n_total_threads)++; \
  THR_STAT_INC(n_forks); \
  ASYNC_CALL(EXP); \
  FORK_POINT_X(iff); \
} while(0)

#define INVALID_PROC_FORK_X(EXP, iff) PROC_FORK_X(INVALID_CALL(EXP), iff)

#if !defined(STHREADS_NOPP)
#define PROC_FORK(EXP) \
do { \
  struct invalid_frame_desc _iff[1]; \
  CHECK_TSS_INIT(); \
  PROC_FORK_X(EXP, _iff); \
} while(0)
#else  /* !defined(STHREADS_NOPP) */
#define PROC_FORK(EXP) EXP
#endif /* !defined(STHREADS_NOPP) */

/* synonym */
#define ST_THREAD_CREATE(EXP) PROC_FORK(EXP)
#define ST_THR_CREATE(EXP) PROC_FORK(EXP)

#ifndef THREAD_STOLEN_HOOK
#define THREAD_STOLEN_HOOK() do{}while(0)
#endif /* THREAD_STOLEN_HOOK */

#ifndef THREAD_BLOCKED_HOOK
#define THREAD_BLOCKED_HOOK() do{}while(0)
#endif /* THREAD_BLOCKED_HOOK */

#ifndef THREAD_CHILD_STOLEN_HOOK
#define THREAD_CHILD_STOLEN_HOOK() do{}while(0)
#endif /* THREAD_CHILD_BLOCKED_HOOK */

#endif /* !__ST_THRCRT_H__ */

