/* 
 * st_lock.inc
 */

/* 
 * Copyright (c) 1999 by Kenjiro Taura, Akinori Yonezawa. All rights reserved.
 * Copyright (c) 1999 by Yoshihiro Oyama, Toshio Endo. All rights reserved.
 * Copyright (c) 1999 by Kunio Tabata. All rights reserved.
 * Copyright (c) 1999 by Mitsubishi Research Institute.  All rights reserved.
 * Copyright (c) 1999 by Information-technology Promotion Agency.  All rights reserved.
 *
 * THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
 * OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
 *
 * Permission is hereby granted to use or copy this program
 * for any purpose,  provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */

/* this file is included from st_shm.c many times. 
   before including this file,
   SHM_TYPE, 
   SHM_TYPE_SIZE, 
   SHM_STRIP_TAG, 
   SHM_ATTATCH_TAG, 
   must be set */

PRIVATE int 
SHM_TRY_READ_AND_LOCK_ANY_AUX(SHM_LOC_T * l, int elem_size, int n, 
			      SHM_TYPE * r,
			      int n_tries, int n_tries_before_sleep)
{
  int i;
  for (i = 0; i < n_tries; i++) {
    int j;
    if (i != 0) st_sleep_os_thread_ms(1);
    /* try N_TRIES_BEFORE_SLEEP times scanning L[0] ... L[N-1] */
    for (j = 0; j < n_tries_before_sleep; j++) {
      int p;
      void * lp;
      int contending = 0;

      /* scan { [l + k * elem_size] | 0 <= k < n } */
      for (p = 0, lp = (void *)l; p < n; p++, lp += elem_size) {
	long x = (long)((SHM_LOC_T *)lp)->v;
	if ((x & 3) == 0) {
	  x = SHM_SET_LSB((void *)&((SHM_LOC_T *)lp)->v);
	  if (x & 3) {
	    /* failed. the location has just been locked by somebody else */
	    contending = 1;
	  } else {
	    *r = (SHM_TYPE)SHM_STRIP_TAG(x);
	    return p;
	  }
	}
      }
      if (contending) j--;
    }
  }
  return -1;
}

PUBLIC SHM_TYPE SHM_READ(SHM_LOC_T * l)
{
#if HAVE_CMP_AND_SWAP || HAVE_LL_SC
  return (SHM_TYPE)SHM_STRIP_TAG(l->v);
#elif HAVE_SWAP
  long x = (long)l->v;
  int i, j;
  if (x != 2) return (SHM_TYPE)SHM_STRIP_TAG(x);
  for (i = 0; i < 10; i++) {
    for (j = 0; j < 10; j++) {
      long x = (long)l->v;
      if (x != 1) return (SHM_TYPE)SHM_STRIP_TAG(x);
      x = (long)l->v;
    }
    st_sleep_os_thread_ms(1);
  }
  spin_wait_error((void *)l);
  return 0;
#else
#error "HAVE CMP_AND_SWAP, LL_SC, or SWAP"
#endif
}

PUBLIC SHM_TYPE SHM_READ_AND_LOCK(SHM_LOC_T * l)
{
  long x = SHM_SET_LSB((void *)(&l->v));
  if ((x & 3) == 0) {
    return (SHM_TYPE)SHM_STRIP_TAG(x);
  } else {
    SHM_TYPE y;
    int i 
      = SHM_TRY_READ_AND_LOCK_ANY_AUX(l, sizeof(SHM_TYPE), 1, &y, 
				      SHM_N_TRIES, SHM_N_TRIES_BEFORE_SLEEP);
    if (i == 0) return y;
    else {
      st_assert(i == -1);
      spin_wait_error((void *)l);
      return 0;
    }
  }
}

PUBLIC int SHM_READ_AND_LOCK_ANY(SHM_LOC_T * l, int el_size, int n, SHM_TYPE * r)
{
  int i 
    = SHM_TRY_READ_AND_LOCK_ANY_AUX(l, el_size, n, r, 
				    SHM_N_TRIES, SHM_N_TRIES_BEFORE_SLEEP);
  if (i == -1) {
    spin_wait_error((void *)l);
    return 0;
  } else {
    return i;
  }
}

PUBLIC int SHM_TRY_READ_AND_LOCK(SHM_LOC_T * l, SHM_TYPE * r)
{
  return SHM_TRY_READ_AND_LOCK_ANY_AUX(l, sizeof(SHM_TYPE), 1, r, 
				       SHM_N_TRIES, SHM_N_TRIES_BEFORE_SLEEP);
}

PUBLIC void SHM_WRITE_AND_UNLOCK(SHM_LOC_T * l, SHM_TYPE x)
{
  l->v = SHM_ATTATCH_TAG(x);
}


