/* 
 * os.c --- os dependent primitives
 */

/* 
 * Copyright (c) 1999 by Kenjiro Taura, Akinori Yonezawa. All rights reserved.
 * Copyright (c) 1999 by Yoshihiro Oyama, Toshio Endo. All rights reserved.
 * Copyright (c) 1999 by Kunio Tabata. All rights reserved.
 * Copyright (c) 1999 by Mitsubishi Research Institute.  All rights reserved.
 * Copyright (c) 1999 by Information-technology Promotion Agency.  All rights reserved.
 *
 * THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
 * OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
 *
 * Permission is hereby granted to use or copy this program
 * for any purpose,  provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */

#include <stdio.h>
#include <st.h>
#include "st_int.h"

/* create a file of name NAME and write CONTENTS (whose size is SIZE bytes) */
GLOBAL void st_create_binary_file(char * name, char * contents, 
				  unsigned int size)
{
#if defined(unix) || defined(__CYGWIN32__)

  FILE * f = fopen(name, "w");
  size_t s;
  if (f == 0) {
    fprintf(st_errout, "%ld : couldn't create file %s\n", 
	    tls(thread_id), name);
    st_wg_die((void *)1);
  }
  s = fwrite(contents, 1, size, f);
  if (s != size) {
    fprintf(st_errout, "%ld : couldn't write contents to %s\n", 
	    tls(thread_id), name);
    st_wg_die((void *)1);
  }
  if (fclose(f) != 0) {
    fprintf(st_errout, "%ld : couldn't close %s\n", 
	    tls(thread_id), name);
    st_wg_die((void *)1);
  }
#elif defined(_WIN32)

#error "do this on win32"

#else

#error "no way to create a file"

#endif
}

